/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network;

import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.storage.disk.StorageDiskSync;
import com.raoulvdberge.refinedstorage.apiimpl.storage.disk.StorageDiskSyncData;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageStorageDiskSizeResponse
implements IMessage,
IMessageHandler<MessageStorageDiskSizeResponse, IMessage> {
    private UUID id;
    private long stored;
    private long capacity;

    public MessageStorageDiskSizeResponse() {
    }

    public MessageStorageDiskSizeResponse(UUID id, long stored, long capacity) {
        this.id = id;
        this.stored = stored;
        this.capacity = capacity;
    }

    public void fromBytes(ByteBuf buf) {
        this.id = new UUID(buf.readLong(), buf.readLong());
        this.stored = buf.readLong();
        this.capacity = buf.readLong();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.id.getMostSignificantBits());
        buf.writeLong(this.id.getLeastSignificantBits());
        buf.writeLong(this.stored);
        buf.writeLong(this.capacity);
    }

    public IMessage onMessage(MessageStorageDiskSizeResponse message, MessageContext ctx) {
        ((StorageDiskSync)API.instance().getStorageDiskSync()).setData(message.id, new StorageDiskSyncData(message.stored, message.capacity));
        return null;
    }
}

